;****************************************************************
;*								*
;*	   SDS VDB 8024 VIDEO DISPLAY BOARD FIRMWARE		*
;*		TO EMULATE AN ADM-31 OR TVI-912			*
;*								*
;****************************************************************
;
;		Date	5th October, 1980
;
;		Version 1.71
;
;		Modifications for ADM/TVI emulation
;		by:
;			Bill Bolton
;			Software Tools
;			P.O. Box 80
;			Newport Beach
;			NSW, 2106
;			AUSTRALIA
;
;
REG0	EQU	80H		;HORIZONTAL LINE COUNT
REG1	EQU	81H		;MODE/HSYNC WIDTH/HSYNC DELAY
REG2	EQU	82H		;SCANS PER DATA ROW/CHARS PER DATA ROW
REG3	EQU	83H		;SKEW BITS/DATA ROWS PER FRAME
REG4	EQU	84H		;SCAN LINES PER FRAME
REG5	EQU	85H		;VERTICAL DATA START
REG6	EQU	86H		;LAST DISPLAYED DATA ROW
RESET	EQU	8AH		;RESET 5027
WCCHAR	EQU	8CH		;WRITE CURSOR CHARACTER/COLUMN ADDRESS
WCLINE	EQU	8DH		;WRITE CURSOR LINE ADDRESS
STIME	EQU	8EH		;START TIMING CHAIN
;
VDBIN	EQU	20H		;INPUT PORT FOR CHARACTERS FROM SYSTEM
ROWS	EQU	24		;NUMBER OF ROWS
COLUMN	EQU	80		;NUMBER OF COLUMNS
STACK	EQU	2000H		;STACK TOP
SCREEN	EQU	1000H		;START OF DISPLAY MEMORY
;
SPACE	EQU	20H		;ASCII BLANK
;
;
	NAME	VDB171
;
	ORG	0
;
;	POWER UP INITIALISATION
;
START:
	LD	SP,STACK
	IN	A,(VDBIN)	;CLEAR INTERUPT FLIP FLOP
	IN	A,(030H)	;CLEAR KEYBOARD READY
	EXX
	LD	L,0
	EXX
	CALL	INIT
	CALL	CLEAR
	LD	HL,SCREEN	;DISPLAY MEMORY ADDRESS
	IM	1
	SCF
	EI
	HALT
;
;	START OF INTERUPT DRIVEN PROGRAM
;
	ORG	00038H
;
	RET	NC
	POP	IY
	EXX
	BIT	7,L
	EXX
	IN	A,(VDBIN)	;GET A CHARACTER
	RES	7,A
	JR	Z,NEXT
	OR	080H
NEXT:
	BIT	6,A			;CONTROL CHARACTER ?
	JP	NZ,TDIS
	BIT	5,A
	JP	Z,CTR
TDIS:
	CALL	PROTECT
;
;	DISPLAY A CHARACTER
;
DISPLAY:
	LD	(HL),A			;MOVE CHAR TO DISPLAY MEMORY
NODIS:
	INC	D
CHECK:
	LD	A,COLUMN
	CP	D		;END OF LINE ?
	JP	Z,LFCR
	INC	HL
	LD	A,D
	OUT	(WCCHAR),A	;MOVE CURSOR TO NEXT SPACE
	SCF
	EI
	HALT
;
;	CONTROL CHARCTER DISPATCHER
;
CTR:
	LD	IY,HLT
	PUSH	IY		;SAVE RETURN ADDRESS
	RES	7,A
	CP	00AH		;LINE FEED
	JP	Z,LF
	CP	00DH		;CARRIAGE RETURN
	JP	Z,CR
	CP	008H		;BACKSPACE
	JP	Z,CTRH
	CP	009H		;TAB MODULO 8
	JP	Z,TAB
	CP	00BH		;CURSOR UP
	JP	Z,UPLINE
	CP	00CH		;CURSOR RIGHT
	JP	Z,RIGHT
	CP	01AH		;CLEAR SCREEN
	JP	Z,CLEAR
	CP	01BH		;ESCAPE
	JP	Z,ESC
	CP	01EH		;HOME CURSOR
	JP	Z,HOME
	CP	01FH		;NEW LINE
	JP	Z,LFCR
	POP	IY
	JR	HLT
;
;	INITIALISE CRT 5027 VIDEO CHIP
;
INIT:
	OUT	(STIME),A
	OUT	(RESET),A
	LD	A,065H
	OUT	(REG0),A
	LD	A,04BH
	OUT	(REG1),A
	LD	A,04DH
	OUT	(REG2),A
	LD	A,0D7H
	OUT	(REG3),A
	LD	A,01DH
	OUT	(REG4),A
	LD	A,025H
	OUT	(REG5),A
	LD	A,017H
	LD	B,A
	OUT	(REG6),A
	LD	A,0
	OUT	(WCCHAR),A
	OUT	(WCLINE),A
	OUT	(STIME),A
	LD	DE,0
	RET
;
;	NEW LINE
;
LFCR:
	CALL	LF
	CALL	CR
HLT:
	SCF			;RETURN FROM CONTROLS
	EI
	HALT
;
;	LINE FEED
;
LF:
	LD	A,E
	CP	B
	CALL	Z,SCRL
	INC	A
	CP	ROWS
	JP	NZ,LFRT
	LD	A,0
LFRT:
	LD	E,A		;REG E HAS LINE NO.
	OUT	(WCLINE),A
	LD	L,D
	LD	H,E
	RL	L
	RR	H
	RR	L
	SET	4,H
	RET
;
;	CARRIAGE RETURN
;
CR:
	LD	D,0
	LD	A,D
	OUT	(WCCHAR),A
	LD	A,080H
	AND	L
	LD	L,A
	RET
;
;	BACKSPACE (CURSOR LEFT)
;
CTRH:
	LD	A,0
	CP	D
	RET	Z
	DEC	D
	DEC	HL
	LD	A,D
	OUT	(WCCHAR),A
	RET
;
;	SCROLL SCREEN UP
;
SCRL:
	INC	B
	LD	A,B
	CP	ROWS
	JP	NZ,SCR2
	LD	B,0
SCR2:
	LD	L,0
	LD	H,B
	RR	H
	RR	L
	SET	4,H
	LD	C,SPACE
	LD	A,COLUMN
	ADD	A,L
SCRLP:
	LD	(HL),C
	INC	HL
	CP	L
	JP	NZ,SCRLP
	LD	A,B
	OUT	(REG6),A
	LD	A,E
	JP	PLACE
;
;	FILL SCREEN WITH BLANK CHARACTERS
;
CLEAR:
	LD	A,008H
	OUT	(010H),A
	LD	HL,SCREEN
	LD	C,SPACE
CLR1:
	LD	A,COLUMN
CLR:
	LD	(HL),C
	INC	HL
	CP	L
	JP	NZ,CLR
	LD	A,0D0H
CLR2:
	LD	(HL),C
	INC	HL
	CP	L
	JP	NZ,CLR2
	LD	A,01BH
	CP	H
	JP	NZ,CLR1
	CALL	HOME
	LD	A,SPACE
	OUT	(010H),A
	EX	AF,AF'
	RET
;
;	CURSOR UP
;
UPLINE:
	LD	A,E
	CP	0
	JP	NZ,UPLD
	LD	A,ROWS
UPLD:
	DEC	A
	CP	B
	RET	Z
	LD	E,A
;
;	PLACE CURSOR AT POSITION SPECIFIED IN DE
;
PLACE:
	LD	H,E
	LD	L,D
	RL	L
	RR	H
	RR	L
	SET	4,H
	LD	A,D
	OUT	(WCCHAR),A
	LD	A,E
	OUT	(WCLINE),A
	RET
;
;	CURSOR RIGHT
;
RIGHT:
	INC	D
	POP	IX
	JP	CHECK
;
;	HOME CURSOR
;
HOME:
	LD	D,0
	LD	A,B
	INC	A
	CP	ROWS
	JP	NZ,HOLP
	LD	A,0
HOLP:
	LD	E,A
	CALL	PLACE
	RET
;
;	ESCAPE SEQUENCES
;
ESC:
	SCF
	CCF			;CLEAR CARRY FLAG, WILL CAUSE
	EI			;  RETURN AFTER INTERUPT
	HALT
;
	IN	A,(VDBIN)	;GET A CHARACTER
	RES	7,A
	CP	'='		;POSITION CURSOR?
	JP	Z,POSIT
	CP	'*'		;CLEAR SCREEN?
	JP	Z,CLEAR
	CP	':'		;CLEAR SCREEN?
	JP	Z,CLEAR
	CP	'T'		;ERASE TO EOL?
	JP	Z,EOL
	CP	'Y'		;ERASE TO END OF SCREEN?
	JP	Z,EOS
	CP	'E'		;INSERT LINE?
	JP	Z,HLT
	CP	'R'		;DELETE LINE?
	JP	Z,HLT
	CP	'G'		;ATTRIBUTE?
	JP	Z,ATTRIB
	CP	'&'		;HALF INTENSITY?
	JP	Z,HALF
	CP	27H		;FULL INTENSITY (27H=')
	JP	Z,FULL
	RET


POSIT:
	SCF
	CCF
	EI
	HALT
;
	IN	A,(VDBIN)	;GET Y VALUE
	RES	7,A
	SUB	SPACE
	RET	M
	CP	ROWS		;TEST FOR > 24
	RET	P
	ADD	A,B
	INC	A
	CP	ROWS
	JP	M,ESLP
	SUB	ROWS
ESLP:
	LD	C,A
	SCF
	CCF
	EI
	HALT
;
	IN	A,(VDBIN)	;GET X VALUE
	RES	7,A
	SUB	SPACE
	RET	M
	CP	COLUMN		;TEST FOR > 80
	RET	P
	LD	E,C
	LD	D,A
	CALL	PLACE
	RET
;
;	TAB SET EVERY 8 SPACES
;
TAB:
	LD	A,0F8H
	AND	D
	ADD	A,008H
	CP	COLUMN
	RET	Z
	LD	D,A
	CALL	PLACE
	RET
;
;
;	AF' REG CONTAINS SPECIAL CONTROL STATUS
;	ENHANCEMENT FUNCTION, CONTROLLED THROUGH
;	PORT 10H
;
;
;	BIT 7	CONTROLS ENHANCEMENT FIELD
;	BIT 6	CONTROLS SPECIAL BIT #1
;	BIT 5	CONTROLS RUNNING TIME
;	BIT 4	CONTROLS UNDERLINE
;	BIT 3	CONTROLS BLANKING
;	BIT 2	CONTROLS REVERSE
;	BIT 1	CONTROLS BLINKING
;	BIT 0	CONTROLS SPECIAL BIT #2
;
;
BLINK:
	EX	AF,AF'
	AND	069H
	OR	022H
	OUT	(010H),A
	EX	AF,AF'
	JR	ENHANC
;
RVS:
	EX	AF,AF'
	AND	069H
	OR	024H
	OUT	(010H),A
	EX	AF,AF'
	JR	ENHANC
;
RVB:
	EX	AF,AF'
	AND	069H
	OR	026H
	OUT	(010H),A
	EX	AF,AF'
ENHANC:
	EXX
	SET	7,L
	EXX
	RET
;
QUIT:
	EX	AF,AF'
	RES	7,A
	OUT	(010H),A
	EX	AF,AF'
QUIT1:
	EXX
	RES	7,L
	EXX
	RET
;
;	SET HALF INTENSITY
;
HALF:
	EX	AF,AF'
	SET	6,A
	OUT	(010H),A
	EX	AF,AF'
	RET
;
;	SET FULL INTENSITY
;
FULL:
	EX	AF,AF'
	RES	6,A
	OUT	(010H),A
	EX	AF,AF'
	RET
;
SC2:
	EX	AF,AF'
	SET	0,A
	OUT	(010H),A
	EX	AF,AF'
	RET
;
RC2:
	EX	AF,AF'
	RES	0,A
	OUT	(010H),A
	EX	AF,AF'
	RET
;
;	PROTECTED FIELD MODE
;
PROTECT:
	EXX
	BIT	0,L			;BIT 0 OF REG L' SETS PROTECT
	EXX
	RET	Z
	BIT	7,(HL)			;BIT 7 OF MEMORY IS PROTECT BIT
	RET	Z
	POP	IY
	JP	NODIS
;
NFD:
	EX	AF,AF'
	AND	069H
	SET	7,A
	OUT	(010H),A
	EX	AF,AF'
	JP	QUIT1
;
PFD:
	EXX
	SET	0,L
	EXX
	RET
;
UNPFD:
	EXX
	RES	0,L
	EXX
	RET
;
;	ERASE TO END OF LINE
;
EOL:
	LD	A,D		;A <--- COLUMN NO.
	PUSH	HL		;SAVE CURSOR LOCATION
	LD	C,SPACE
ELOOP:
	LD	(HL),C		;WRITE A SPACE
	INC	A
	INC	HL
	CP	COLUMN		;AT LAST COLUMN?
	JR	NZ,ELOOP		;NO
	POP	HL		;YES, GET CURSOR LOCATION
	RET
;
;	ERASE TO END OF SCREEN
;
EOS:
	PUSH	DE		;SAVE ROW/COLUMN VALUES
SLOOP:
	CALL	EOL		;ERASE TO END OF CURRENT LINE
	LD	D,0		;ERASE ENTIRE LINE
	CALL	LF		;NEXT LINE
	LD	A,B
	CP	E		;ON FINAL ROW?
	JR	NZ,SLOOP	;NO
	CALL	EOL		;YES,ERASE LAST LINE
	POP	DE		;GET ROW/COLUMN VALUES
	CALL	PLACE		;RESTORE CURSOR
	RET
;
;	VIDEO ATTRIBUTES
;
ATTRIB:
	SCF
	CCF
	EI
	HALT
;
	IN	A,(VDBIN)	;GET NEXT CHARACTER
	RES	7,A
	CP	'0'		;RESET TO STANDARD VIDEO?
	JP	Z,QUIT
	CP	'2'		;SET BLINK VIDEO
	JP	Z,BLINK
	CP	'4'		;SET REVERSE VIDEO?
	JP	Z,RVS
	CP	'6'		;SET REVERSE & BLINK VIDEO?
	JP	Z,RVB
	RET
;
	END	START

